<?php
/*--------------------------------------------------------------------
 RepositoryInterface.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository;

use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Exceptions\ProductDoesNotHaveAnyCombinationsException;
use Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository\DTO\CombisIdDtoCollection;

/**
 * Interface RepositoryInterface
 * @package Gambio\Shop\SellingUnit\Database\Price\PropertyInformation\Repository
 */
interface RepositoryInterface
{
    /**
     * @param ProductId $productId
     *
     * @return CombisIdDtoCollection
     * @throws ProductDoesNotHaveAnyCombinationsException
     */
    public function availableCombisIds(ProductId $productId): CombisIdDtoCollection;
}